// ==UserScript==
// @name VU.Viewer
// @description Просмотр тестов на videouroki.net
// @author timoxa0
// @license GPLv3
// @version 1.2
// @match https://videouroki.net/et/pupil/*
// @match https://videouroki.net/et/pupil
// ==/UserScript==
(function (window, undefined) {
    // Normalazing window as w and preverting from running in frame
    var w;
    if (typeof unsafeWindow != undefined) {
        w = unsafeWindow
    } else {
        w = window;
    }
    if (w.self != w.top) {
        return;
    }

    // Additioanal url check
    if (/https:\/\/videouroki.net/.test(w.location.href)) {

        // Find element inside another one
        function findInside(parentElm, classname) {
            let tmp = [];
            let all = document.getElementsByClassName("material_item_column")
            for (let i = 0; i < all.length; i++) {
                let parent = all[i] ? all[i].parentNode : {};
                if (parent === parentElm) { tmp.push(all[i]); }
            }
            return tmp
        }

        // Find element by XPath
        function getElementByXpath(path) {
            return document.evaluate(path, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
        }

        function getRandomInt(max) {
            return Math.floor(Math.random() * max);
        }

        // Open test page
        function viewTest(id) {
            fetch("https://videouroki.net/tests/api/beginTest/" + id, {
                method: "POST",
                body: JSON.stringify({
                    "member": {
                        "id": false,
                        "lastname": "Иванов",
                        "firstname": "Иван",
                        "classTxt":  (getRandomInt(2) + 9) + "А"
                    },
                    "related": 0
                }),
                headers: {
                    "Content-type": "application/json; charset=UTF-8"
                }
            }).then((response) => response.json()).then((json) => {
                window.open("https://videouroki.net/tests/do/" + json.uuid, "_blank");
                navigator.clipboard.writeText(json.uuid).then(() => {},() => {
                    console.error('Не удалось скопировать UUID');
                });
            })
        }

        function copyId (id) {
            navigator.clipboard.writeText(id).then(() => {
                alert("ID теста скопирован")
            },() => {
                console.error('Не удалось скопировать ID');
            });
        }

        const tests = w.backend.pupil.tests;
        var testDivs = document.getElementsByClassName("test material_item");
        for (let i = 0; i < testDivs.length; i++) {

            // Setting up environment
            let testDiv = testDivs[i];
            let nameDiv = findInside(testDiv, "material_item_column")[0];
            let btnDiv = findInside(testDiv, "material_item_column")[1];
            let name = nameDiv.childNodes[nameDiv.childNodes.length-1].textContent.trim(); // Test name filter
            let test = tests.find(o => o.test.title === name).test;

            // Creting button
            let viewBtn = document.createElement("a");
            let copyBtn = document.createElement("a");
            let span = document.createElement("span");
            let small = document.createElement("small");
            span.style = "color: lightgrey;";
            span.textContent = " | ";
            viewBtn.href = "#";
            viewBtn.textContent = "Просмотр";
            viewBtn.id = "view" + test.fakeId;
            copyBtn.href = "#";
            copyBtn.textContent = "ID";
            copyBtn.id = "copyId" + test.fakeId;
            small.appendChild(span);
            small.appendChild(viewBtn);
            small.appendChild(span.cloneNode(true));
            small.appendChild(copyBtn);
            btnDiv.appendChild(small);

            // Adding click acktion
            document.getElementById("view" + test.fakeId).addEventListener("click", () => {viewTest(test.fakeId)});
            document.getElementById("copyId" + test.fakeId).addEventListener("click", () => {copyId(test.fakeId)});
        }
    }
})(window);